//Listing 18.8. Przykad wykorzystania klas wyjtkw zwizanych poprzez dziedziczenie
#include <iostream>
#include <cfloat>
using namespace std;

class MSG {
       static char* data []; // wewntrzne dane statyczne
public:
       static char* msg(int n) // publiczna metoda statyczna
       { if (n<1 || n > 5) // sprawd poprawno indeksu
             return data[0];
         else
             return data[n]; } // zwr poprawny acuch znakowy
} ;

char* MSG::data [] = { "\nNiepoprawny argument funkcji msg()\n",
"\nZerowy mianownik nie jest dozwolony \n\n", // tablica tekstw
"\nMianownik ujemny: ",
"Podaj licznik oraz nieujemny\n",
"mianownik (dowolna litera aby zakoczy): ",
"Warto uamka: "
} ;

class ZeroDenom {
protected:
       char *msg;
public:
       ZeroDenom (char* message) : msg(message)
       { }
       void print () const
       { cout << msg; }
} ;

class NegativeDenom : public ZeroDenom {
       long val;
public:
       NegativeDenom(char *message, long value)
         : ZeroDenom(message), val(value) { }
       void print () const
       { cout << msg << val << "\n\n"; }
} ;

inline void inverse(long value, double& answer)
           throw (ZeroDenom, NegativeDenom)
{ answer = (value) ? 1.0/value : DBL_MAX;
  if (answer==DBL_MAX)
         throw ZeroDenom(MSG::msg(1));
  if (value < 0)
         throw NegativeDenom(MSG::msg(2), value); }

inline void fraction (long numer, long denom, double& result)
         throw (ZeroDenom, NegativeDenom)
{ inverse(denom, result); // result = 1.0 / denom
  result = numer * result; } // result = numer / denom

int main()
{
  while (true)
  { long numer, denom; double ans; // llicznik/mianownik
    cout << MSG::msg(3) << MSG::msg(4); // popro o dane uytkownika
    if ((cin >> numer >> denom) == 0) break; // wprowad dane
    try {
      fraction(numer,denom,ans); // oblicz wynik
      cout << MSG::msg(5) << ans <<"\n\n"; } // poprawna warto
    catch (const ZeroDenom &zd) // mianownik zerowy
    { zd.print(); }
    catch (const NegativeDenom &nd) // warto ujemna
    { nd.print(); } } // koniec ptli
  return 0;
}
